# Abflug clients v2.4.0

End-user applications for Abflug multiplayer.

## Main applications

| File | Description |
|------|-------------|
| **abflug_gui.py** | GUI client: forwards simulator GPS to the server, registers flight plan |
| **rewinger.py** | Traffic viewer: map, own aircraft, nearby traffic, callsign from server |

## Quick start

1. **Config**
   - Copy `abflug.json.example` → `abflug.json`
   - Set `api_key` and optionally `server` (default: `https://abflug.cloud`)

2. **Launcher (easiest)**
   - Open a terminal in this folder (`abflug_vX.Y.Z_variant`).
   - Run:
     ```bash
     python launcher.py
     ```
   - Pick **Abflug Client** or **Rewinger** from the GUI.
   - **Windows, no console:** use `launcher.pyw` (double‑click or `pythonw launcher.pyw`).

3. **Or run apps directly**
   - Abflug Client: `python abflug_gui.py`
   - Rewinger: `python rewinger.py`

## Required files (do not remove)

- **launcher.py** – launcher GUI (run `python launcher.py`)
- **abflug_gui.py**, **rewinger.py** – main apps
- **abflug_client_web.py** – used by the GUI
- **simulator_data_source.py** – GPS from UDP/FSWidget
- **aircraft_status.py** – used by abflug_client_web
- **config_utils.py** – loads `abflug.json` / `butter.json`
- **dpi_utils.py** – DPI scaling
- **discord_hooks_module.py** – optional Discord webhooks
- **abflug.json.example** – config template
- **aircraft_icon.png**, **traffic_icon.png** – map icons for Rewinger

## Optional

- **launcher.pyw** – no‑console launcher on Windows (double‑click or `pythonw launcher.pyw`)
- **selected_traffic.png** – Rewinger selected-aircraft icon (fallback if missing)
- **abflug.json** or **butter.json** – your API key and server (create from example)

## Windows: “Downloaded from internet”

Scripts run from a downloaded zip are often blocked. To avoid that:

1. **Unblock before extracting:** Right‑click the downloaded zip → **Properties** → check **Unblock** → OK, then extract.
2. **Or** run from a terminal: `cd` into this folder, then `python launcher.py`. No double‑click needed.
3. **Avoid .bat:** We use `launcher.py` / `launcher.pyw` instead of `.bat`; they are less likely to be blocked, and work the same from a terminal.


## FSWidget / Aerofly Mobile

- Use **FSWidget TCP** when the simulator runs on another device (e.g. phone).
- Use **Autodetect** in both Abflug Client and Rewinger to find the simulator IP.

