import requests
from datetime import datetime
def prepare_flight_data_for_discord(flight_number, departure_airport, arrival_airport, departure_time, arrival_time, pilot,action="",gate="",runway=""):
    current_time = datetime.now().strftime("%H:%M")
    # Initialize content to None to catch any missing cases
    content = None
    
    if action == "departing":
        # Handle departure_time - might be empty string or None
        if departure_time and departure_time.strip():
            try:
                dep_time_str = datetime.strptime(departure_time, "%Y-%m-%d %H:%M:%S").strftime("%H:%M")
            except (ValueError, TypeError):
                dep_time_str = datetime.now().strftime("%H:%M")
        else:
            dep_time_str = datetime.now().strftime("%H:%M")
        content = f"Taking off from {departure_airport} → {arrival_airport} at {dep_time_str} from runway {runway}"
    elif action == "landed":
        # Handle arrival_time - might be empty string or None
        if arrival_time and arrival_time.strip():
            try:
                arr_time_str = datetime.strptime(arrival_time, "%Y-%m-%d %H:%M:%S").strftime("%H:%M")
            except (ValueError, TypeError):
                arr_time_str = datetime.now().strftime("%H:%M")
        else:
            arr_time_str = datetime.now().strftime("%H:%M")
        content = f"Landed at {arrival_airport} from {departure_airport} at {arr_time_str} on runway {runway}"
    elif action == "in flight":
        # Handle departure_time - might be empty string or None
        if departure_time and departure_time.strip():
            try:
                dep_time_str = datetime.strptime(departure_time, "%Y-%m-%d %H:%M:%S").strftime("%H:%M")
            except (ValueError, TypeError):
                dep_time_str = datetime.now().strftime("%H:%M")
        else:
            dep_time_str = datetime.now().strftime("%H:%M")
        content = f"In flight from {departure_airport} to {arrival_airport} runway {runway} since {dep_time_str} from gate {gate}"
    elif action == "taxiing":
        content = f"Taxiing at {departure_airport} from gate {gate} to runway {runway}"
    
    # Return None if action is invalid or content wasn't set
    if content is None:
        return None
    
    return {
        "content": content,
        "embeds": [
            {
                "title": f"Flight {flight_number}",
                "description": content,
                "color": get_color_code("Aqua")
            }
        ]
    }
def get_color_code(color_name):
    if color_name == "Default":
        return 0
    elif color_name == "Aqua":
        return 1752220
    elif color_name == "DarkAqua":
        return 1146986
    elif color_name == "Green":
        return 5763719
    elif color_name == "DarkGreen":
        return 2067276
    elif color_name == "Blue":
        return 3447003
    elif color_name == "DarkBlue":
        return 2123412
    elif color_name == "Purple":
        return 10181046
    elif color_name == "DarkPurple":
        return 7419530
    elif color_name == "LuminousVividPink":
        return 15277667
    elif color_name == "DarkVividPink":
        return 11342935
    elif color_name == "Gold":
        return 15844367
    elif color_name == "DarkGold":
        return 12745742
    elif color_name == "Orange":
        return 15105570
    elif color_name == "DarkOrange":
        return 11027200
    elif color_name == "Red":
        return 15548997
    elif color_name == "DarkRed":
        return 10038562
    elif color_name == "Grey":
        return 9807270
    elif color_name == "DarkGrey":
        return 9936031
    elif color_name == "DarkerGrey":
        return 8359053
    elif color_name == "LightGrey":
        return 12370112
    elif color_name == "Navy":
        return 3426654
    elif color_name == "DarkNavy":
        return 2899536
    elif color_name == "Yellow":
        return 16776960
    else:
        return 0



if __name__ == "__main__":

    webhook_url = "https://discord.com/api/webhooks/1455898702823555237/d_ojHQLAyTY8TJixPyHVyOzi1e-EpNjIkEMCt0ILXtsUlRFUbtVBlJSh8nSsDRAjWr_k"
    flight_data = prepare_flight_data_for_discord("AZ321", "LOWG", "EDDF", "15 mins", "15 mins", "merritt130","departure","B24","09L")
    if flight_data:
        requests.post(webhook_url, json=flight_data)
    else:
        print("Invalid flight data")